#Main Function (Run this function after loading all required functions)
#Required Functions to be loaded: Pattern, Pat_div, Ref_Creat, Stat_pat1, Stat_pat2, Stat_Pat3, Stat_pat4, Ref_Creat1, matc
#This function accepts raw survey data as input and gives the results of PCSD3 clustering as output 

library(XLConnect)

Da = loadWorkbook("D:/Roopam/Manuscripts/Survey_Data.xlsx") #loading the datasheet

D_orig = as.matrix(readWorksheet(Da, sheet = "WO_Admin", header = TRUE)) #Selecting worksheet

svy_scl= 4                       #Maximum range of Survey Scale

len = 11                         #Total Number of variables in the Survey

Raw1 = Pattern(D_orig,svy_scl)   # Finding the Directional patterns of data (Direction vector)

Raw2 = Pat_div(Raw1)             # Division of patterns on the basis of respondent categories

Reference = Ref_creat(Raw2,len)  #Creating the reference vector of each respondent group

clust = matc(Raw1,Reference)     # Maching the direction vectors and reference vectors

writeWorksheetToFile("D:/Roopam/Manuscripts/Survey_Data.xlsx",clust,sheet="Cluster") # Loading the resutls of clustering on the worksheet
